/**
 * 配置文件
 * 存储后端 API 地址等配置信息
 */

// ===========================================
// 环境选择：1=开发环境  2=生产环境
// ===========================================
const ENVIRONMENT = 2;

// ===========================================
// 环境配置
// ===========================================
const ENV_CONFIG = {
  // 开发环境
  development: {
    API_BASE_URL: 'http://localhost:3001',
  },
  // 生产环境
  production: {
    API_BASE_URL: 'https://api.mikeyang.ai',
  },
};

// 根据环境选择配置
const currentEnv = ENVIRONMENT === 1 ? 'development' : 'production';
const envSettings = ENV_CONFIG[currentEnv];

const CONFIG = {
  // 当前环境
  ENVIRONMENT: currentEnv,
  
  // 后端 API 地址（根据环境自动切换）
  API_BASE_URL: envSettings.API_BASE_URL,
  
  // API 端点
  API_ENDPOINTS: {
    HEALTH: '/health',
    TRANSLATE_TO_ZH: '/api/translation/to-zh',
    TRANSLATE_TO_EN: '/api/translation/to-en',
    REPLY_SUGGESTIONS: '/api/reply/suggestions',
    REPLY_CHAT: '/api/reply/chat',
    VERSION_CHECK: '/api/version',
  },
  
  // 请求超时时间（毫秒）
  REQUEST_TIMEOUT: 30000,
  
  // 缓存配置
  CACHE: {
    ENABLED: true,
    MAX_SIZE: 50, // 最多缓存 50 条记录
    TTL: 3600000, // 缓存有效期 1 小时
  },
};

// 导出配置（用于模块化）
if (typeof module !== 'undefined' && module.exports) {
  module.exports = CONFIG;
}

