/**
 * Deutsch (German) Translation
 */
export default {
  appName: 'fluentx',
  
  nav: {
    generalSettings: 'Allgemeine Einstellungen',
    subscriptionActivation: 'Abonnement & Aktivierung',
  },
  
  settings: {
    title: 'Allgemeine Einstellungen',
    description: 'Konfigurieren Sie Ihre Spracheinstellungen und Kontoeinstellungen.',
    language: {
      title: 'Wählen Sie Ihre Sprache',
      description: 'Wählen Sie Ihre bevorzugte Sprache für Übersetzungen und Antworten.',
    },
    account: {
      title: 'Kontoeinstellungen',
      logout: 'Abmelden',
      logoutConfirm: 'Möchten Sie sich wirklich abmelden?',
      logoutSuccess: 'Erfolgreich abgemeldet',
    },
  },
  
  subscription: {
    title: 'Abonnement & Aktivierung',
    description: 'Verwalten Sie Ihren Testzeitraum und Abonnementstatus.',
    loginPrompt: {
      title: 'Melden Sie sich an, um Ihr Abonnement zu verwalten',
      description: 'Bitte melden Sie sich bei Ihrem Konto an, um den Testzeitraum zu aktivieren oder fluentx zu abonnieren.',
      button: 'Zu Allgemeinen Einstellungen',
    },
    status: {
      inactive: {
        title: 'Testzeitraum Nicht Aktiviert',
        description: 'Sie benötigen einen Aktivierungscode, um Ihren 7-tägigen kostenlosen Testzeitraum zu starten.<br>Geben Sie Ihren Code unten ein.',
      },
      trial: {
        title: 'Testzeitraum Aktiv',
        description: '{days} Tag(e) verbleibend in Ihrem Testzeitraum<br>Läuft ab am {date}',
        daysLeft: '{days} Tag(e)',
      },
      active: {
        title: 'Premium Aktiv',
        description: 'Ihr Abonnement ist aktiv<br>Verlängert am {date}',
      },
      visitWebsite: 'Website Besuchen',
      expired: {
        title: 'Abonnement Abgelaufen',
        description: 'Ihr {type} ist abgelaufen.<br>Geben Sie einen neuen Aktivierungscode ein, um Ihren Testzeitraum fortzusetzen.',
        typeTrial: 'Testzeitraum',
        typeSubscription: 'Abonnement',
      },
    },
    activation: {
      title: 'Aktivierungscode',
      placeholder: 'Geben Sie Ihren Aktivierungscode ein',
      button: 'Aktivieren',
      buttonActivating: 'Aktivierung...',
      success: '✅ Testzeitraum erfolgreich aktiviert!',
      errorRequired: 'Bitte geben Sie einen Aktivierungscode ein',
      errorInvalid: '❌ {message}',
      
      howToGet: {
        title: '📝 So erhalten Sie den Aktivierungscode:',
        step1_part1: 'Öffnen Sie das X-Profil von',
        step1_part2: '',
        step2_part1: 'Antworten Sie auf den angepinnten Tweet:',
        step3: 'Geben Sie den erhaltenen Aktivierungscode unten ein',
        linkText: '@Mike_yanger',
        replyText: 'Aktivierungscode benötigt',
      },
    },
  },
  
  login: {
    title: 'Willkommen bei fluentx',
    subtitle: 'KI-gestützter X/Twitter-Antwortassistent',
    prompt: {
      title: 'Melden Sie sich an, um alle Funktionen freizuschalten',
      description: 'Erhalten Sie unbegrenzte Übersetzungen, intelligente Antworten und mehr!',
    },
    button: {
      google: 'Mit Google fortfahren',
      loggingIn: 'Anmeldung...',
    },
    privacy: 'Wir greifen nur auf Ihre E-Mail und grundlegende Profilinformationen zu. Ihre Daten sind sicher und werden niemals geteilt.',
    error: 'Anmeldung fehlgeschlagen. Bitte versuchen Sie es erneut.',
  },
  
  extension: {
    translate: {
      button: 'Übersetzen',
      translating: 'Übersetzung...',
      error: 'Übersetzung fehlgeschlagen',
      copySuccess: 'Kopiert',
      summaryTitle: '📝 Zusammenfassung',
      summaryPrefix: '💡 ',
    },
    reply: {
      button: 'Antwort Generieren',
      generating: 'Generierung...',
      error: 'Generierung fehlgeschlagen',
      placeholder: 'Wählen Sie einen Antwortvorschlag...',
    },
    access: {
      noAccess: 'Sie müssen den Testzeitraum aktivieren oder abonnieren, um diese Funktion zu nutzen',
      expired: 'Ihr Abonnement ist abgelaufen',
      goToSettings: 'Zu Einstellungen',
    },
  },
  
  languages: {
    en: 'English',
    'zh-CN': '简体中文',
    'zh-TW': '繁體中文',
    ja: '日本語',
    ko: '한국어',
    es: 'Español',
    fr: 'Français',
    de: 'Deutsch',
    pt: 'Português',
    ru: 'Русский',
  },
  
  messages: {
    success: 'Erfolg',
    error: 'Fehler',
    loading: 'Laden...',
    saved: 'Gespeichert',
    languageSaved: 'Spracheinstellung gespeichert!',
  },
};

