/**
 * English Translation
 */
export default {
  // ==================== Common ====================
  appName: 'FluentX',
  
  // ==================== Options - Navigation ====================
  nav: {
    generalSettings: 'General Settings',
    subscriptionActivation: 'Subscription & Activation',
  },
  
  // ==================== Options - General Settings ====================
  settings: {
    title: 'General Settings',
    description: 'Configure your language preferences and account settings.',
    
    // Language Selection
    language: {
      title: 'Select Your Language',
      description: 'Choose your preferred language for translations and replies.',
    },
    
    // Account Settings
    account: {
      title: 'Account Settings',
      logout: 'Logout',
      logoutConfirm: 'Are you sure you want to logout?',
      logoutSuccess: 'Logged out successfully',
    },
    
    // Feature Settings
    features: {
      title: 'Feature Settings',
      description: 'Enable or disable specific features.',
      tweetTranslateButton: {
        title: 'Tweet Translate Button',
        description: 'Show a translate button below each tweet for quick translation.',
        enabled: 'Tweet translate button enabled',
        disabled: 'Tweet translate button disabled',
      },
    },
  },
  
  // ==================== Options - Subscription ====================
  subscription: {
    title: 'Subscription & Activation',
    description: 'Manage your trial and subscription status.',
    
    // Login Prompt
    loginPrompt: {
      title: 'Sign in to manage your subscription',
      description: 'Please sign in to your account to activate trial or subscribe to fluentx.',
      button: 'Go to General Settings',
    },
    
    // Subscription Status
    status: {
      inactive: {
        title: 'Trial Not Activated',
        description: 'You need an activation code to start your 7-day free trial.<br>Enter your code below to activate.',
      },
      trial: {
        title: 'Trial Active',
        description: '{days} day(s) remaining in your trial<br>Expires on {date}',
        daysLeft: '{days} day(s)',
      },
      active: {
        title: 'Premium Active',
        description: 'Your subscription is active<br>Renews on {date}',
      },
      visitWebsite: 'Visit Website',
      expired: {
        title: 'Subscription Expired',
        description: 'Your {type} has expired.<br>Enter a new activation code below to continue your trial.',
        typeTrial: 'trial',
        typeSubscription: 'subscription',
      },
    },
    
    // Activation Code
    activation: {
      title: 'Activation Code',
      placeholder: 'Enter your activation code',
      button: 'Activate',
      buttonActivating: 'Activating...',
      success: '✅ Trial activated successfully!',
      errorRequired: 'Please enter an activation code',
      errorInvalid: '❌ {message}',
      
      // How to get activation code
      howToGet: {
        title: '📝 How to Get Activation Code:',
        step1_part1: 'Open',
        step1_part2: '\'s X profile',
        step2_part1: 'Reply to the pinned tweet:',
        step3: 'Enter the activation code you received below',
        linkText: '@Mike_yanger',
        replyText: 'Need activation code',
      },
    },
  },
  
  // ==================== Login Page ====================
  login: {
    title: 'Welcome to fluentx',
    subtitle: 'AI-powered X/Twitter reply assistant',
    
    prompt: {
      title: 'Sign in to unlock full features',
      description: 'Get unlimited translations, smart replies, and more!',
    },
    
    button: {
      google: 'Continue with Google',
      loggingIn: 'Logging in...',
    },
    
    privacy: 'We only access your email and basic profile information. Your data is secure and never shared.',
    error: 'Login failed. Please try again.',
  },
  
  // ==================== Extension Features ====================
  extension: {
    // Translation
    translate: {
      button: 'Translate',
      translating: 'Translating...',
      error: 'Translation failed',
      copySuccess: 'Copied',
      summaryTitle: '📝 Summary',
      summaryPrefix: '💡 ',
    },
    
    // Reply Suggestions
    reply: {
      button: 'Generate Reply',
      generating: 'Generating...',
      error: 'Generation failed',
      placeholder: 'Select a reply suggestion...',
    },
    
    // Access Control
    access: {
      noAccess: 'You need to activate trial or subscribe to use this feature',
      expired: 'Your subscription has expired',
      goToSettings: 'Go to Settings',
    },
  },
  
  // ==================== Language Names ====================
  languages: {
    en: 'English',
    'zh-CN': '简体中文',
    'zh-TW': '繁體中文',
    ja: '日本語',
    ko: '한국어',
    es: 'Español',
    fr: 'Français',
    de: 'Deutsch',
    pt: 'Português',
    ru: 'Русский',
  },
  
  // ==================== Common Messages ====================
  messages: {
    success: 'Success',
    error: 'Error',
    loading: 'Loading...',
    saved: 'Saved',
    languageSaved: 'Language preference saved!',
  },
};

