/**
 * Español (Spanish) Translation
 */
export default {
  appName: 'fluentx',
  
  nav: {
    generalSettings: 'Configuración General',
    subscriptionActivation: 'Suscripción y Activación',
  },
  
  settings: {
    title: 'Configuración General',
    description: 'Configure sus preferencias de idioma y configuración de cuenta.',
    language: {
      title: 'Seleccione su idioma',
      description: 'Elija su idioma preferido para traducciones y respuestas.',
    },
    account: {
      title: 'Configuración de Cuenta',
      logout: 'Cerrar Sesión',
      logoutConfirm: '¿Está seguro de que desea cerrar sesión?',
      logoutSuccess: 'Sesión cerrada correctamente',
    },
  },
  
  subscription: {
    title: 'Suscripción y Activación',
    description: 'Administre su prueba y estado de suscripción.',
    loginPrompt: {
      title: 'Inicie sesión para administrar su suscripción',
      description: 'Inicie sesión en su cuenta para activar la prueba o suscribirse a fluentx.',
      button: 'Ir a Configuración General',
    },
    status: {
      inactive: {
        title: 'Prueba No Activada',
        description: 'Necesita un código de activación para comenzar su prueba gratuita de 7 días.<br>Ingrese su código a continuación.',
      },
      trial: {
        title: 'Prueba Activa',
        description: '{days} día(s) restantes en su prueba<br>Expira el {date}',
        daysLeft: '{days} día(s)',
      },
      active: {
        title: 'Premium Activo',
        description: 'Su suscripción está activa<br>Se renueva el {date}',
      },
      visitWebsite: 'Visitar Sitio Web',
      expired: {
        title: 'Suscripción Expirada',
        description: 'Su {type} ha expirado.<br>Ingrese un nuevo código de activación para continuar su prueba.',
        typeTrial: 'prueba',
        typeSubscription: 'suscripción',
      },
    },
    activation: {
      title: 'Código de Activación',
      placeholder: 'Ingrese su código de activación',
      button: 'Activar',
      buttonActivating: 'Activando...',
      success: '✅ ¡Prueba activada correctamente!',
      errorRequired: 'Por favor ingrese un código de activación',
      errorInvalid: '❌ {message}',
      
      howToGet: {
        title: '📝 Cómo obtener el código de activación:',
        step1_part1: 'Abrir el perfil X de',
        step1_part2: '',
        step2_part1: 'Responder al tweet fijado:',
        step3: 'Ingresar el código de activación recibido abajo',
        linkText: '@Mike_yanger',
        replyText: 'Necesito código de activación',
      },
    },
  },
  
  login: {
    title: 'Bienvenido a fluentx',
    subtitle: 'Asistente de respuestas X/Twitter impulsado por IA',
    prompt: {
      title: 'Inicie sesión para desbloquear todas las funciones',
      description: '¡Obtenga traducciones ilimitadas, respuestas inteligentes y más!',
    },
    button: {
      google: 'Continuar con Google',
      loggingIn: 'Iniciando sesión...',
    },
    privacy: 'Solo accedemos a su correo electrónico e información básica del perfil. Sus datos están seguros y nunca se comparten.',
    error: 'Error al iniciar sesión. Por favor, inténtelo de nuevo.',
  },
  
  extension: {
    translate: {
      button: 'Traducir',
      translating: 'Traduciendo...',
      error: 'Error en la traducción',
      copySuccess: 'Copiado',
      summaryTitle: '📝 Resumen',
      summaryPrefix: '💡 ',
    },
    reply: {
      button: 'Generar Respuesta',
      generating: 'Generando...',
      error: 'Error en la generación',
      placeholder: 'Seleccione una sugerencia de respuesta...',
    },
    access: {
      noAccess: 'Necesita activar la prueba o suscribirse para usar esta función',
      expired: 'Su suscripción ha expirado',
      goToSettings: 'Ir a Configuración',
    },
  },
  
  languages: {
    en: 'English',
    'zh-CN': '简体中文',
    'zh-TW': '繁體中文',
    ja: '日本語',
    ko: '한국어',
    es: 'Español',
    fr: 'Français',
    de: 'Deutsch',
    pt: 'Português',
    ru: 'Русский',
  },
  
  messages: {
    success: 'Éxito',
    error: 'Error',
    loading: 'Cargando...',
    saved: 'Guardado',
    languageSaved: '¡Preferencia de idioma guardada!',
  },
};

