/**
 * Français (French) Translation
 */
export default {
  appName: 'fluentx',
  
  nav: {
    generalSettings: 'Paramètres Généraux',
    subscriptionActivation: 'Abonnement et Activation',
  },
  
  settings: {
    title: 'Paramètres Généraux',
    description: 'Configurez vos préférences linguistiques et paramètres de compte.',
    language: {
      title: 'Sélectionnez votre langue',
      description: 'Choisissez votre langue préférée pour les traductions et les réponses.',
    },
    account: {
      title: 'Paramètres du Compte',
      logout: 'Déconnexion',
      logoutConfirm: 'Êtes-vous sûr de vouloir vous déconnecter?',
      logoutSuccess: 'Déconnexion réussie',
    },
  },
  
  subscription: {
    title: 'Abonnement et Activation',
    description: 'Gérez votre essai et votre statut d\'abonnement.',
    loginPrompt: {
      title: 'Connectez-vous pour gérer votre abonnement',
      description: 'Veuillez vous connecter à votre compte pour activer l\'essai ou vous abonner à fluentx.',
      button: 'Aller aux Paramètres Généraux',
    },
    status: {
      inactive: {
        title: 'Essai Non Activé',
        description: 'Vous avez besoin d\'un code d\'activation pour commencer votre essai gratuit de 7 jours.<br>Entrez votre code ci-dessous.',
      },
      trial: {
        title: 'Essai Actif',
        description: '{days} jour(s) restant(s) dans votre essai<br>Expire le {date}',
        daysLeft: '{days} jour(s)',
      },
      active: {
        title: 'Premium Actif',
        description: 'Votre abonnement est actif<br>Renouvellement le {date}',
      },
      visitWebsite: 'Visiter le Site Web',
      expired: {
        title: 'Abonnement Expiré',
        description: 'Votre {type} a expiré.<br>Entrez un nouveau code d\'activation pour continuer votre essai.',
        typeTrial: 'essai',
        typeSubscription: 'abonnement',
      },
    },
    activation: {
      title: 'Code d\'Activation',
      placeholder: 'Entrez votre code d\'activation',
      button: 'Activer',
      buttonActivating: 'Activation...',
      success: '✅ Essai activé avec succès!',
      errorRequired: 'Veuillez entrer un code d\'activation',
      errorInvalid: '❌ {message}',
      
      howToGet: {
        title: '📝 Comment obtenir le code d\'activation :',
        step1_part1: 'Ouvrir le profil X de',
        step1_part2: '',
        step2_part1: 'Répondre au tweet épinglé :',
        step3: 'Entrer le code d\'activation reçu ci-dessous',
        linkText: '@Mike_yanger',
        replyText: 'Besoin d\'un code d\'activation',
      },
    },
  },
  
  login: {
    title: 'Bienvenue sur fluentx',
    subtitle: 'Assistant de réponses X/Twitter alimenté par IA',
    prompt: {
      title: 'Connectez-vous pour débloquer toutes les fonctionnalités',
      description: 'Obtenez des traductions illimitées, des réponses intelligentes et plus encore!',
    },
    button: {
      google: 'Continuer avec Google',
      loggingIn: 'Connexion...',
    },
    privacy: 'Nous accédons uniquement à votre email et à vos informations de profil de base. Vos données sont sécurisées et ne sont jamais partagées.',
    error: 'Échec de la connexion. Veuillez réessayer.',
  },
  
  extension: {
    translate: {
      button: 'Traduire',
      translating: 'Traduction...',
      error: 'Échec de la traduction',
      copySuccess: 'Copié',
      summaryTitle: '📝 Résumé',
      summaryPrefix: '💡 ',
    },
    reply: {
      button: 'Générer une Réponse',
      generating: 'Génération...',
      error: 'Échec de la génération',
      placeholder: 'Sélectionnez une suggestion de réponse...',
    },
    access: {
      noAccess: 'Vous devez activer l\'essai ou vous abonner pour utiliser cette fonctionnalité',
      expired: 'Votre abonnement a expiré',
      goToSettings: 'Aller aux Paramètres',
    },
  },
  
  languages: {
    en: 'English',
    'zh-CN': '简体中文',
    'zh-TW': '繁體中文',
    ja: '日本語',
    ko: '한국어',
    es: 'Español',
    fr: 'Français',
    de: 'Deutsch',
    pt: 'Português',
    ru: 'Русский',
  },
  
  messages: {
    success: 'Succès',
    error: 'Erreur',
    loading: 'Chargement...',
    saved: 'Enregistré',
    languageSaved: 'Préférence linguistique enregistrée!',
  },
};

