/**
 * 日本語翻訳
 */
export default {
  appName: 'fluentx',
  
  nav: {
    generalSettings: '一般設定',
    subscriptionActivation: 'サブスクリプションとアクティベーション',
  },
  
  settings: {
    title: '一般設定',
    description: '言語設定とアカウント設定を構成します。',
    language: {
      title: '言語を選択',
      description: '翻訳と返信に使用する言語を選択してください。',
    },
    account: {
      title: 'アカウント設定',
      logout: 'ログアウト',
      logoutConfirm: 'ログアウトしてもよろしいですか？',
      logoutSuccess: 'ログアウトしました',
    },
  },
  
  subscription: {
    title: 'サブスクリプションとアクティベーション',
    description: 'トライアルとサブスクリプションのステータスを管理します。',
    loginPrompt: {
      title: 'サインインしてサブスクリプションを管理',
      description: 'トライアルをアクティベートまたはfluentxにサブスクライブするには、アカウントにサインインしてください。',
      button: '一般設定に移動',
    },
    status: {
      inactive: {
        title: 'トライアル未アクティベート',
        description: '7日間の無料トライアルを開始するには、アクティベーションコードが必要です。<br>下にコードを入力してください。',
      },
      trial: {
        title: 'トライアル有効',
        description: 'トライアル残り{days}日<br>有効期限：{date}',
        daysLeft: '{days}日',
      },
      active: {
        title: 'プレミアム有効',
        description: 'サブスクリプションは有効です<br>更新日：{date}',
      },
      visitWebsite: '公式サイトへ',
      expired: {
        title: 'サブスクリプション期限切れ',
        description: '{type}の有効期限が切れました。<br>トライアルを続けるには、新しいアクティベーションコードを入力してください。',
        typeTrial: 'トライアル',
        typeSubscription: 'サブスクリプション',
      },
    },
    activation: {
      title: 'アクティベーションコード',
      placeholder: 'アクティベーションコードを入力',
      button: 'アクティベート',
      buttonActivating: 'アクティベート中...',
      success: '✅ トライアルがアクティベートされました！',
      errorRequired: 'アクティベーションコードを入力してください',
      errorInvalid: '❌ {message}',
      
      howToGet: {
        title: '📝 アクティベーションコードの取得方法：',
        step1_part1: '',
        step1_part2: 'の X プロフィールを開く',
        step2_part1: '固定ツイートに返信：',
        step3: '取得したアクティベーションコードを下記に入力',
        linkText: '@Mike_yanger',
        replyText: 'アクティベーションコードが必要',
      },
    },
  },
  
  login: {
    title: 'fluentxへようこそ',
    subtitle: 'AI搭載のX/Twitter返信アシスタント',
    prompt: {
      title: 'サインインして全機能を解除',
      description: '無制限の翻訳、スマート返信などをご利用ください！',
    },
    button: {
      google: 'Googleで続ける',
      loggingIn: 'ログイン中...',
    },
    privacy: 'メールアドレスと基本的なプロフィール情報のみにアクセスします。データは安全で、共有されることはありません。',
    error: 'ログインに失敗しました。もう一度お試しください。',
  },
  
  extension: {
    translate: {
      button: '翻訳',
      translating: '翻訳中...',
      error: '翻訳に失敗しました',
      copySuccess: 'コピーしました',
      summaryTitle: '📝 要約',
      summaryPrefix: '💡 ',
    },
    reply: {
      button: '返信を生成',
      generating: '生成中...',
      error: '生成に失敗しました',
      placeholder: '返信候補を選択...',
    },
    access: {
      noAccess: 'この機能を使用するには、トライアルをアクティベートまたはサブスクライブする必要があります',
      expired: 'サブスクリプションの有効期限が切れました',
      goToSettings: '設定に移動',
    },
  },
  
  languages: {
    en: 'English',
    'zh-CN': '简体中文',
    'zh-TW': '繁體中文',
    ja: '日本語',
    ko: '한국어',
    es: 'Español',
    fr: 'Français',
    de: 'Deutsch',
    pt: 'Português',
    ru: 'Русский',
  },
  
  messages: {
    success: '成功',
    error: 'エラー',
    loading: '読み込み中...',
    saved: '保存しました',
    languageSaved: '言語設定が保存されました！',
  },
};

