/**
 * 한국어 번역
 */
export default {
  appName: 'fluentx',
  
  nav: {
    generalSettings: '일반 설정',
    subscriptionActivation: '구독 및 활성화',
  },
  
  settings: {
    title: '일반 설정',
    description: '언어 기본 설정 및 계정 설정을 구성합니다.',
    language: {
      title: '언어 선택',
      description: '번역 및 답변에 사용할 언어를 선택하세요.',
    },
    account: {
      title: '계정 설정',
      logout: '로그아웃',
      logoutConfirm: '로그아웃하시겠습니까?',
      logoutSuccess: '로그아웃되었습니다',
    },
  },
  
  subscription: {
    title: '구독 및 활성화',
    description: '체험판 및 구독 상태를 관리합니다.',
    loginPrompt: {
      title: '로그인하여 구독 관리',
      description: '체험판을 활성화하거나 fluentx를 구독하려면 계정에 로그인하세요.',
      button: '일반 설정으로 이동',
    },
    status: {
      inactive: {
        title: '체험판 미활성화',
        description: '7일 무료 체험을 시작하려면 활성화 코드가 필요합니다.<br>아래에 코드를 입력하세요.',
      },
      trial: {
        title: '체험판 활성화',
        description: '체험판 남은 기간: {days}일<br>만료일: {date}',
        daysLeft: '{days}일',
      },
      active: {
        title: '프리미엄 활성화',
        description: '구독이 활성화되었습니다<br>갱신일: {date}',
      },
      visitWebsite: '공식 웹사이트 방문',
      expired: {
        title: '구독 만료',
        description: '{type}이(가) 만료되었습니다.<br>체험을 계속하려면 새 활성화 코드를 입력하세요.',
        typeTrial: '체험판',
        typeSubscription: '구독',
      },
    },
    activation: {
      title: '활성화 코드',
      placeholder: '활성화 코드 입력',
      button: '활성화',
      buttonActivating: '활성화 중...',
      success: '✅ 체험판이 활성화되었습니다!',
      errorRequired: '활성화 코드를 입력하세요',
      errorInvalid: '❌ {message}',
      
      howToGet: {
        title: '📝 활성화 코드 받는 방법:',
        step1_part1: '',
        step1_part2: '의 X 프로필 열기',
        step2_part1: '고정된 트윗에 답글:',
        step3: '받은 활성화 코드를 아래에 입력',
        linkText: '@Mike_yanger',
        replyText: '활성화 코드 필요',
      },
    },
  },
  
  login: {
    title: 'fluentx에 오신 것을 환영합니다',
    subtitle: 'AI 기반 X/Twitter 답변 도우미',
    prompt: {
      title: '로그인하여 전체 기능 잠금 해제',
      description: '무제한 번역, 스마트 답변 등을 이용하세요!',
    },
    button: {
      google: 'Google로 계속',
      loggingIn: '로그인 중...',
    },
    privacy: '이메일 및 기본 프로필 정보만 액세스합니다. 귀하의 데이터는 안전하며 절대 공유되지 않습니다.',
    error: '로그인에 실패했습니다. 다시 시도하세요.',
  },
  
  extension: {
    translate: {
      button: '번역',
      translating: '번역 중...',
      error: '번역 실패',
      copySuccess: '복사됨',
      summaryTitle: '📝 요약',
      summaryPrefix: '💡 ',
    },
    reply: {
      button: '답변 생성',
      generating: '생성 중...',
      error: '생성 실패',
      placeholder: '답변 제안 선택...',
    },
    access: {
      noAccess: '이 기능을 사용하려면 체험판을 활성화하거나 구독해야 합니다',
      expired: '구독이 만료되었습니다',
      goToSettings: '설정으로 이동',
    },
  },
  
  languages: {
    en: 'English',
    'zh-CN': '简体中文',
    'zh-TW': '繁體中文',
    ja: '日本語',
    ko: '한국어',
    es: 'Español',
    fr: 'Français',
    de: 'Deutsch',
    pt: 'Português',
    ru: 'Русский',
  },
  
  messages: {
    success: '성공',
    error: '오류',
    loading: '로딩 중...',
    saved: '저장됨',
    languageSaved: '언어 기본 설정이 저장되었습니다!',
  },
};

