/**
 * Português (Portuguese) Translation
 */
export default {
  appName: 'fluentx',
  
  nav: {
    generalSettings: 'Configurações Gerais',
    subscriptionActivation: 'Assinatura e Ativação',
  },
  
  settings: {
    title: 'Configurações Gerais',
    description: 'Configure suas preferências de idioma e configurações de conta.',
    language: {
      title: 'Selecione seu idioma',
      description: 'Escolha seu idioma preferido para traduções e respostas.',
    },
    account: {
      title: 'Configurações da Conta',
      logout: 'Sair',
      logoutConfirm: 'Tem certeza de que deseja sair?',
      logoutSuccess: 'Saiu com sucesso',
    },
  },
  
  subscription: {
    title: 'Assinatura e Ativação',
    description: 'Gerencie seu período de teste e status de assinatura.',
    loginPrompt: {
      title: 'Entre para gerenciar sua assinatura',
      description: 'Por favor, entre em sua conta para ativar o período de teste ou assinar o fluentx.',
      button: 'Ir para Configurações Gerais',
    },
    status: {
      inactive: {
        title: 'Período de Teste Não Ativado',
        description: 'Você precisa de um código de ativação para iniciar seu período de teste gratuito de 7 dias.<br>Digite seu código abaixo.',
      },
      trial: {
        title: 'Período de Teste Ativo',
        description: '{days} dia(s) restante(s) no seu período de teste<br>Expira em {date}',
        daysLeft: '{days} dia(s)',
      },
      active: {
        title: 'Premium Ativo',
        description: 'Sua assinatura está ativa<br>Renova em {date}',
      },
      visitWebsite: 'Visitar Site',
      expired: {
        title: 'Assinatura Expirada',
        description: 'Seu {type} expirou.<br>Digite um novo código de ativação para continuar seu período de teste.',
        typeTrial: 'período de teste',
        typeSubscription: 'assinatura',
      },
    },
    activation: {
      title: 'Código de Ativação',
      placeholder: 'Digite seu código de ativação',
      button: 'Ativar',
      buttonActivating: 'Ativando...',
      success: '✅ Período de teste ativado com sucesso!',
      errorRequired: 'Por favor, digite um código de ativação',
      errorInvalid: '❌ {message}',
      
      howToGet: {
        title: '📝 Como obter o código de ativação:',
        step1_part1: 'Abrir o perfil X de',
        step1_part2: '',
        step2_part1: 'Responder ao tweet fixado:',
        step3: 'Inserir o código de ativação recebido abaixo',
        linkText: '@Mike_yanger',
        replyText: 'Preciso de código de ativação',
      },
    },
  },
  
  login: {
    title: 'Bem-vindo ao fluentx',
    subtitle: 'Assistente de respostas X/Twitter com IA',
    prompt: {
      title: 'Entre para desbloquear todos os recursos',
      description: 'Obtenha traduções ilimitadas, respostas inteligentes e mais!',
    },
    button: {
      google: 'Continuar com Google',
      loggingIn: 'Entrando...',
    },
    privacy: 'Acessamos apenas seu email e informações básicas do perfil. Seus dados são seguros e nunca compartilhados.',
    error: 'Falha no login. Por favor, tente novamente.',
  },
  
  extension: {
    translate: {
      button: 'Traduzir',
      translating: 'Traduzindo...',
      error: 'Falha na tradução',
      copySuccess: 'Copiado',
      summaryTitle: '📝 Resumo',
      summaryPrefix: '💡 ',
    },
    reply: {
      button: 'Gerar Resposta',
      generating: 'Gerando...',
      error: 'Falha na geração',
      placeholder: 'Selecione uma sugestão de resposta...',
    },
    access: {
      noAccess: 'Você precisa ativar o período de teste ou assinar para usar este recurso',
      expired: 'Sua assinatura expirou',
      goToSettings: 'Ir para Configurações',
    },
  },
  
  languages: {
    en: 'English',
    'zh-CN': '简体中文',
    'zh-TW': '繁體中文',
    ja: '日本語',
    ko: '한국어',
    es: 'Español',
    fr: 'Français',
    de: 'Deutsch',
    pt: 'Português',
    ru: 'Русский',
  },
  
  messages: {
    success: 'Sucesso',
    error: 'Erro',
    loading: 'Carregando...',
    saved: 'Salvo',
    languageSaved: 'Preferência de idioma salva!',
  },
};

