/**
 * Русский (Russian) Translation
 */
export default {
  appName: 'fluentx',
  
  nav: {
    generalSettings: 'Общие Настройки',
    subscriptionActivation: 'Подписка и Активация',
  },
  
  settings: {
    title: 'Общие Настройки',
    description: 'Настройте языковые предпочтения и параметры учетной записи.',
    language: {
      title: 'Выберите язык',
      description: 'Выберите предпочитаемый язык для переводов и ответов.',
    },
    account: {
      title: 'Настройки Учетной Записи',
      logout: 'Выйти',
      logoutConfirm: 'Вы уверены, что хотите выйти?',
      logoutSuccess: 'Вы успешно вышли',
    },
  },
  
  subscription: {
    title: 'Подписка и Активация',
    description: 'Управляйте пробным периодом и статусом подписки.',
    loginPrompt: {
      title: 'Войдите для управления подпиской',
      description: 'Пожалуйста, войдите в свою учетную запись, чтобы активировать пробную версию или подписаться на fluentx.',
      button: 'Перейти к Общим Настройкам',
    },
    status: {
      inactive: {
        title: 'Пробная Версия Не Активирована',
        description: 'Вам нужен код активации, чтобы начать 7-дневную бесплатную пробную версию.<br>Введите код ниже.',
      },
      trial: {
        title: 'Пробная Версия Активна',
        description: 'Осталось {days} дн. пробного периода<br>Истекает {date}',
        daysLeft: '{days} дн.',
      },
      active: {
        title: 'Premium Активен',
        description: 'Ваша подписка активна<br>Продление {date}',
      },
      visitWebsite: 'Посетить Сайт',
      expired: {
        title: 'Подписка Истекла',
        description: 'Ваш {type} истек.<br>Введите новый код активации, чтобы продолжить пробный период.',
        typeTrial: 'пробный период',
        typeSubscription: 'подписка',
      },
    },
    activation: {
      title: 'Код Активации',
      placeholder: 'Введите код активации',
      button: 'Активировать',
      buttonActivating: 'Активация...',
      success: '✅ Пробная версия успешно активирована!',
      errorRequired: 'Пожалуйста, введите код активации',
      errorInvalid: '❌ {message}',
      
      howToGet: {
        title: '📝 Как получить код активации:',
        step1_part1: 'Откройте профиль X',
        step1_part2: '',
        step2_part1: 'Ответьте на закрепленный твит:',
        step3: 'Введите полученный код активации ниже',
        linkText: '@Mike_yanger',
        replyText: 'Нужен код активации',
      },
    },
  },
  
  login: {
    title: 'Добро пожаловать в fluentx',
    subtitle: 'Помощник ответов X/Twitter на основе ИИ',
    prompt: {
      title: 'Войдите, чтобы разблокировать все функции',
      description: 'Получите неограниченные переводы, умные ответы и многое другое!',
    },
    button: {
      google: 'Продолжить с Google',
      loggingIn: 'Вход...',
    },
    privacy: 'Мы получаем доступ только к вашей электронной почте и основной информации профиля. Ваши данные в безопасности и никогда не передаются третьим лицам.',
    error: 'Ошибка входа. Пожалуйста, попробуйте снова.',
  },
  
  extension: {
    translate: {
      button: 'Перевести',
      translating: 'Перевод...',
      error: 'Ошибка перевода',
      copySuccess: 'Скопировано',
      summaryTitle: '📝 Резюме',
      summaryPrefix: '💡 ',
    },
    reply: {
      button: 'Создать Ответ',
      generating: 'Создание...',
      error: 'Ошибка создания',
      placeholder: 'Выберите вариант ответа...',
    },
    access: {
      noAccess: 'Вам нужно активировать пробную версию или подписаться, чтобы использовать эту функцию',
      expired: 'Ваша подписка истекла',
      goToSettings: 'Перейти к Настройкам',
    },
  },
  
  languages: {
    en: 'English',
    'zh-CN': '简体中文',
    'zh-TW': '繁體中文',
    ja: '日本語',
    ko: '한국어',
    es: 'Español',
    fr: 'Français',
    de: 'Deutsch',
    pt: 'Português',
    ru: 'Русский',
  },
  
  messages: {
    success: 'Успех',
    error: 'Ошибка',
    loading: 'Загрузка...',
    saved: 'Сохранено',
    languageSaved: 'Языковые предпочтения сохранены!',
  },
};

