/**
 * 简体中文翻译
 */
export default {
  // ==================== 通用 ====================
  appName: 'FluentX',
  
  // ==================== 个人中心 - 导航菜单 ====================
  nav: {
    generalSettings: '通用设置',
    subscriptionActivation: '订阅与激活',
  },
  
  // ==================== 个人中心 - 通用设置页面 ====================
  settings: {
    title: '通用设置',
    description: '配置您的语言偏好和账户设置。',
    
    // 语言选择
    language: {
      title: '选择您的语言',
      description: '选择您的首选语言进行翻译和回复。',
    },
    
    // 账户设置
    account: {
      title: '账户设置',
      logout: '退出登录',
      logoutConfirm: '确定要退出登录吗？',
      logoutSuccess: '已成功退出',
    },
    
    // 功能设置
    features: {
      title: '功能设置',
      description: '启用或禁用特定功能。',
      tweetTranslateButton: {
        title: '推文翻译按钮',
        description: '在每个推文下方显示翻译按钮，方便快速翻译。',
        enabled: '推文翻译按钮已启用',
        disabled: '推文翻译按钮已禁用',
      },
    },
  },
  
  // ==================== 个人中心 - 订阅页面 ====================
  subscription: {
    title: '订阅与激活',
    description: '管理您的试用和订阅状态。',
    
    // 未登录提示
    loginPrompt: {
      title: '登录以管理您的订阅',
      description: '请先登录您的账户以激活试用或订阅 fluentx。',
      button: '前往通用设置',
    },
    
    // 订阅状态
    status: {
      inactive: {
        title: '试用未激活',
        description: '您需要激活码来开始 7 天免费试用。<br>在下方输入您的激活码。',
      },
      trial: {
        title: '试用激活',
        description: '您的试用还剩 {days} 天<br>到期日期：{date}',
        daysLeft: '{days} 天',
      },
      active: {
        title: '高级会员激活',
        description: '您的订阅处于激活状态<br>续订日期：{date}',
      },
      visitWebsite: '访问官网',
      expired: {
        title: '订阅已过期',
        description: '您的{type}已过期。<br>在下方输入新的激活码以继续试用。',
        typeTrial: '试用',
        typeSubscription: '订阅',
      },
    },
    
    // 激活码
    activation: {
      title: '激活码',
      placeholder: '输入您的激活码',
      button: '激活',
      buttonActivating: '激活中...',
      success: '✅ 试用激活成功！',
      errorRequired: '请输入激活码',
      errorInvalid: '❌ {message}',
      
      // 获取激活码说明
      howToGet: {
        title: '📝 如何获取激活码：',
        step1_part1: '打开',
        step1_part2: '的 X 主页',
        step2_part1: '在置顶推文下回复：',
        step3: '获取激活码后填入下方输入框',
        linkText: '@Mike_yanger',
        replyText: '需要激活码',
      },
    },
  },
  
  // ==================== 登录页面 ====================
  login: {
    title: '欢迎使用 fluentx',
    subtitle: 'AI 驱动的 X/Twitter 回复助手',
    
    prompt: {
      title: '登录以解锁完整功能',
      description: '获得无限翻译、智能回复等更多功能！',
    },
    
    button: {
      google: '使用 Google 继续',
      loggingIn: '登录中...',
    },
    
    privacy: '我们只访问您的电子邮件和基本资料信息。您的数据是安全的，永远不会被分享。',
    error: '登录失败，请重试。',
  },
  
  // ==================== 插件功能页面 ====================
  extension: {
    // 翻译功能
    translate: {
      button: '翻译',
      translating: '翻译中...',
      error: '翻译失败',
      copySuccess: '已复制',
      summaryTitle: '📝 内容摘要',
      summaryPrefix: '💡 ',
    },
    
    // 回复建议
    reply: {
      button: '生成回复',
      generating: '生成中...',
      error: '生成失败',
      placeholder: '选择一个回复建议...',
    },
    
    // 权限提示
    access: {
      noAccess: '您需要激活试用或订阅才能使用此功能',
      expired: '您的订阅已过期',
      goToSettings: '前往设置',
    },
  },
  
  // ==================== 语言名称 ====================
  languages: {
    en: 'English',
    'zh-CN': '简体中文',
    'zh-TW': '繁體中文',
    ja: '日本語',
    ko: '한국어',
    es: 'Español',
    fr: 'Français',
    de: 'Deutsch',
    pt: 'Português',
    ru: 'Русский',
  },
  
  // ==================== 通用消息 ====================
  messages: {
    success: '操作成功',
    error: '操作失败',
    loading: '加载中...',
    saved: '已保存',
    languageSaved: '语言偏好已保存！',
  },
};

