/**
 * 繁體中文翻譯
 */
export default {
  appName: 'FluentX',
  
  nav: {
    generalSettings: '通用設定',
    subscriptionActivation: '訂閱與啟動',
  },
  
  settings: {
    title: '通用設定',
    description: '配置您的語言偏好和帳戶設定。',
    language: {
      title: '選擇您的語言',
      description: '選擇您的首選語言進行翻譯和回覆。',
    },
    account: {
      title: '帳戶設定',
      logout: '登出',
      logoutConfirm: '確定要登出嗎？',
      logoutSuccess: '已成功登出',
    },
  },
  
  subscription: {
    title: '訂閱與啟動',
    description: '管理您的試用和訂閱狀態。',
    loginPrompt: {
      title: '登入以管理您的訂閱',
      description: '請先登入您的帳戶以啟動試用或訂閱 fluentx。',
      button: '前往通用設定',
    },
    status: {
      inactive: {
        title: '試用未啟動',
        description: '您需要啟動碼來開始 7 天免費試用。<br>在下方輸入您的啟動碼。',
      },
      trial: {
        title: '試用啟動',
        description: '您的試用還剩 {days} 天<br>到期日期：{date}',
        daysLeft: '{days} 天',
      },
      active: {
        title: '高級會員啟動',
        description: '您的訂閱處於啟動狀態<br>續訂日期：{date}',
      },
      visitWebsite: '訪問官網',
      expired: {
        title: '訂閱已過期',
        description: '您的{type}已過期。<br>在下方輸入新的啟動碼以繼續試用。',
        typeTrial: '試用',
        typeSubscription: '訂閱',
      },
    },
    activation: {
      title: '啟動碼',
      placeholder: '輸入您的啟動碼',
      button: '啟動',
      buttonActivating: '啟動中...',
      success: '✅ 試用啟動成功！',
      errorRequired: '請輸入啟動碼',
      errorInvalid: '❌ {message}',
      
      howToGet: {
        title: '📝 如何獲取啟動碼：',
        step1_part1: '打開',
        step1_part2: '的 X 主頁',
        step2_part1: '在置頂推文下回覆：',
        step3: '獲取啟動碼後填入下方輸入框',
        linkText: '@Mike_yanger',
        replyText: '需要啟動碼',
      },
    },
  },
  
  login: {
    title: '歡迎使用 fluentx',
    subtitle: 'AI 驅動的 X/Twitter 回覆助手',
    prompt: {
      title: '登入以解鎖完整功能',
      description: '獲得無限翻譯、智能回覆等更多功能！',
    },
    button: {
      google: '使用 Google 繼續',
      loggingIn: '登入中...',
    },
    privacy: '我們只訪問您的電子郵件和基本資料資訊。您的數據是安全的，永遠不會被分享。',
    error: '登入失敗，請重試。',
  },
  
  extension: {
    translate: {
      button: '翻譯',
      translating: '翻譯中...',
      error: '翻譯失敗',
      copySuccess: '已複製',
      summaryTitle: '📝 內容摘要',
      summaryPrefix: '💡 ',
    },
    reply: {
      button: '生成回覆',
      generating: '生成中...',
      error: '生成失敗',
      placeholder: '選擇一個回覆建議...',
    },
    access: {
      noAccess: '您需要啟動試用或訂閱才能使用此功能',
      expired: '您的訂閱已過期',
      goToSettings: '前往設定',
    },
  },
  
  languages: {
    en: 'English',
    'zh-CN': '简体中文',
    'zh-TW': '繁體中文',
    ja: '日本語',
    ko: '한국어',
    es: 'Español',
    fr: 'Français',
    de: 'Deutsch',
    pt: 'Português',
    ru: 'Русский',
  },
  
  messages: {
    success: '操作成功',
    error: '操作失敗',
    loading: '載入中...',
    saved: '已保存',
    languageSaved: '語言偏好已保存！',
  },
};

