/**
 * 国际化消息配置
 * 所有界面文案的多语言翻译
 */

const MESSAGES = {
  'zh-CN': {
    // 侧边栏
    sidebarTitle: 'FluentX推文助手',
    welcomeTitle: '✨ 选择推文，自动翻译并生成回复建议',
    welcomeText: '👆 在页面上选择任意推文，即可自动翻译并生成3种风格的回复建议',
    quickTranslateTitle: '💬 快捷翻译（直接输入文字翻译）',
    dividerText: '或',
    summaryTitle: '📝 内容摘要',
    summaryPrefix: '💡 ',
    tweetTranslation: '📝 推文翻译',
    customReply: '✍️ 自定义回复',
    customReplyPlaceholder: '在此输入中文，点击翻译按钮转换成英文...',
    translateButton: '翻译',
    translateTweetButton: '翻译推文',
    chatButton: '聊天',
    refreshReplies: '🔄 换一批',
    translating: '正在翻译推文...',
    generatingReplies: '正在生成回复建议...',
    replySuggestions: '💡 回复建议',
    copyButton: '复制',
    copied: '已复制！',
    loading: '正在处理中...',
    error: '处理失败，请重试',
    retry: '重试',
    minimize: '最小化',
    expand: '展开',
    
    // 回复类型
    supportiveReply: '支持性回复',
    inquisitiveReply: '提问式回复',
    neutralReply: '中立性回复',
    
    // 欢迎消息列表
    welcomeFeature1: '📝 中文翻译',
    welcomeFeature2: '💡 智能回复建议',
    welcomeFeature3: '✍️ 自定义回复翻译',
    welcomeTip: '💡 提示：直接用鼠标选中推文内容即可',
    
    // 权限提示
    noAccessTitle: '需要订阅或激活',
    noAccessMessage: '请订阅或输入新的激活码',
    goToSettings: '前往设置',
  },
  
  'zh-TW': {
    sidebarTitle: 'FluentX推文助手',
    welcomeTitle: '✨ 選擇推文，自動翻譯並生成回覆建議',
    welcomeText: '👆 在頁面上選擇任意推文，即可自動翻譯並生成3種風格的回覆建議',
    quickTranslateTitle: '💬 快捷翻譯（直接輸入文字翻譯）',
    dividerText: '或',
    summaryTitle: '📝 內容摘要',
    summaryPrefix: '💡 ',
    tweetTranslation: '📝 推文翻譯',
    customReply: '✍️ 自定義回覆',
    customReplyPlaceholder: '在此輸入中文，點擊翻譯按鈕轉換成英文...',
    translateButton: '翻譯',
    translateTweetButton: '翻譯推文',
    chatButton: '聊天',
    refreshReplies: '🔄 換一批',
    translating: '翻譯中...',
    replySuggestions: '💡 回覆建議',
    copyButton: '複製',
    copied: '已複製！',
    loading: '正在處理中...',
    error: '處理失敗，請重試',
    retry: '重試',
    minimize: '最小化',
    expand: '展開',
    supportiveReply: '支持性回覆',
    inquisitiveReply: '提問式回覆',
    neutralReply: '中立性回覆',
    welcomeFeature1: '📝 中文翻譯',
    welcomeFeature2: '💡 智能回覆建議',
    welcomeFeature3: '✍️ 自定義回覆翻譯',
    welcomeTip: '💡 提示：直接用鼠標選中推文內容即可',
    
    // 權限提示
    noAccessTitle: '需要訂閱或激活',
    noAccessMessage: '請訂閱或輸入新的激活碼',
    goToSettings: '前往設置',
  },
  
  'en': {
    sidebarTitle: 'FluentX Tweet Assistant',
    welcomeTitle: '✨ Select Tweet to Auto-Translate & Generate Replies',
    welcomeText: '👆 Select any tweet on the page to automatically translate and generate 3 styles of reply suggestions',
    quickTranslateTitle: '💬 Quick Translate (Direct Text Input)',
    dividerText: 'or',
    summaryTitle: '📝 Summary',
    summaryPrefix: '💡 ',
    tweetTranslation: '📝 Tweet Translation',
    customReply: '✍️ Custom Reply',
    customReplyPlaceholder: 'Enter your text here, click translate to convert to English...',
    translateButton: 'Translate',
    translateTweetButton: 'Translate Tweet',
    chatButton: 'Chat',
    refreshReplies: '🔄 Refresh',
    translating: 'Translating tweet...',
    generatingReplies: 'Generating reply suggestions...',
    replySuggestions: '💡 Reply Suggestions',
    copyButton: 'Copy',
    copied: 'Copied!',
    loading: 'Processing...',
    error: 'Failed, please retry',
    retry: 'Retry',
    minimize: 'Minimize',
    expand: 'Expand',
    supportiveReply: 'Supportive Reply',
    inquisitiveReply: 'Inquisitive Reply',
    neutralReply: 'Neutral Reply',
    welcomeFeature1: '📝 Translation',
    welcomeFeature2: '💡 Smart Reply Suggestions',
    welcomeFeature3: '✍️ Custom Reply Translation',
    welcomeTip: '💡 Tip: Simply select tweet content with your mouse',
    
    // Access Control
    noAccessTitle: 'Subscription Required',
    noAccessMessage: 'Please subscribe or enter a new activation code',
    goToSettings: 'Go to Settings',
  },
  
  'ja': {
    sidebarTitle: 'FluentXツイートアシスタント',
    welcomeTitle: '✨ ツイートを選択して自動翻訳と返信候補を生成',
    welcomeText: '👆 ページ上の任意のツイートを選択すると、自動的に翻訳され、3つのスタイルの返信候補が生成されます',
    quickTranslateTitle: '💬 クイック翻訳（直接テキスト入力）',
    dividerText: 'または',
    summaryTitle: '📝 要約',
    summaryPrefix: '💡 ',
    tweetTranslation: '📝 ツイート翻訳',
    customReply: '✍️ カスタム返信',
    customReplyPlaceholder: 'ここにテキストを入力し、翻訳ボタンをクリックして英語に変換...',
    translateButton: '翻訳',
    translateTweetButton: 'ツイートを翻訳',
    chatButton: 'チャット',
    refreshReplies: '🔄 更新',
    translating: 'ツイートを翻訳中...',
    generatingReplies: '返信候補を生成中...',
    replySuggestions: '💡 返信候補',
    copyButton: 'コピー',
    copied: 'コピーしました！',
    loading: '処理中...',
    error: '失敗しました。再試行してください',
    retry: '再試行',
    minimize: '最小化',
    expand: '展開',
    supportiveReply: '支持的な返信',
    inquisitiveReply: '質問的な返信',
    neutralReply: '中立的な返信',
    welcomeFeature1: '📝 翻訳',
    welcomeFeature2: '💡 スマート返信候補',
    welcomeFeature3: '✍️ カスタム返信翻訳',
    welcomeTip: '💡 ヒント：マウスでツイートを選択するだけです',
    noAccessTitle: 'サブスクリプションが必要',
    noAccessMessage: 'サブスクリプションまたは新しいアクティベーションコードを入力してください',
    goToSettings: '設定へ',
  },
  
  'ko': {
    sidebarTitle: 'FluentX 트윗 도우미',    
    welcomeTitle: '✨ 트윗 선택하여 자동 번역 및 답변 제안 생성',
    welcomeText: '👆 페이지에서 임의의 트윗을 선택하면 자동으로 번역되고 3가지 스타일의 답변 제안이 생성됩니다',
    quickTranslateTitle: '💬 빠른 번역（직접 텍스트 입력）',
    dividerText: '또는',
    summaryTitle: '📝 요약',
    summaryPrefix: '💡 ',
    tweetTranslation: '📝 트윗 번역',
    customReply: '✍️ 사용자 정의 답변',
    customReplyPlaceholder: '여기에 텍스트를 입력하고 번역 버튼을 클릭하여 영어로 변환...',
    translateButton: '번역',
    translateTweetButton: '트윗 번역',
    chatButton: '채팅',
    refreshReplies: '🔄 새로고침',
    translating: '트윗 번역 중...',
    generatingReplies: '답글 제안 생성 중...',
    replySuggestions: '💡 답변 제안',
    copyButton: '복사',
    copied: '복사됨!',
    loading: '처리 중...',
    error: '실패, 다시 시도해주세요',
    retry: '재시도',
    minimize: '최소화',
    expand: '확장',
    supportiveReply: '지지하는 답변',
    inquisitiveReply: '질문하는 답변',
    neutralReply: '중립적인 답변',
    welcomeFeature1: '📝 번역',
    welcomeFeature2: '💡 스마트 답변 제안',
    welcomeFeature3: '✍️ 사용자 정의 답변 번역',
    welcomeTip: '💡 팁: 마우스로 트윗 내용을 선택하기만 하면 됩니다',
    noAccessTitle: '구독 필요',
    noAccessMessage: '구독하거나 새로운 활성화 코드를 입력하세요',
    goToSettings: '설정으로',
  },
  
  'es': {
    sidebarTitle: 'Asistente de Tweets FluentX',
    welcomeTitle: '✨ Selecciona Tweet para Traducir y Generar Respuestas',
    welcomeText: '👆 Selecciona cualquier tweet en la página para traducirlo automáticamente y generar 3 estilos de sugerencias de respuesta',
    quickTranslateTitle: '💬 Traducción Rápida (Entrada Directa de Texto)',
    dividerText: 'o',
    summaryTitle: '📝 Resumen',
    summaryPrefix: '💡 ',
    tweetTranslation: '📝 Traducción de Tweet',
    customReply: '✍️ Respuesta Personalizada',
    customReplyPlaceholder: 'Ingresa tu texto aquí, haz clic en traducir para convertir al inglés...',
    translateButton: 'Traducir',
    translateTweetButton: 'Traducir Tweet',
    chatButton: 'Chat',
    refreshReplies: '🔄 Refrescar',
    translating: 'Traduciendo tweet...',
    generatingReplies: 'Generando sugerencias de respuesta...',
    replySuggestions: '💡 Sugerencias de Respuesta',
    copyButton: 'Copiar',
    copied: '¡Copiado!',
    loading: 'Procesando...',
    error: 'Error, por favor reintenta',
    retry: 'Reintentar',
    minimize: 'Minimizar',
    expand: 'Expandir',
    supportiveReply: 'Respuesta de Apoyo',
    inquisitiveReply: 'Respuesta Inquisitiva',
    neutralReply: 'Respuesta Neutral',
    welcomeFeature1: '📝 Traducción',
    welcomeFeature2: '💡 Sugerencias Inteligentes',
    welcomeFeature3: '✍️ Traducción Personalizada',
    welcomeTip: '💡 Consejo: Simplemente selecciona el contenido del tweet con tu ratón',
    noAccessTitle: 'Suscripción Requerida',
    noAccessMessage: 'Por favor suscríbete o ingresa un nuevo código de activación',
    goToSettings: 'Ir a Configuración',
  },
  
  'fr': {
    sidebarTitle: 'Assistant de Tweets FluentX',
    welcomeTitle: '✨ Sélectionnez un Tweet pour Traduire et Générer des Réponses',
    welcomeText: '👆 Sélectionnez n\'importe quel tweet sur la page pour le traduire automatiquement et générer 3 styles de suggestions de réponse',
    quickTranslateTitle: '💬 Traduction Rapide (Saisie Directe de Texte)',
    dividerText: 'ou',
    summaryTitle: '📝 Résumé',
    summaryPrefix: '💡 ',
    tweetTranslation: '📝 Traduction de Tweet',
    customReply: '✍️ Réponse Personnalisée',
    customReplyPlaceholder: 'Entrez votre texte ici, cliquez sur traduire pour convertir en anglais...',
    translateButton: 'Traduire',
    translateTweetButton: 'Traduire le Tweet',
    chatButton: 'Chat',
    refreshReplies: '🔄 Actualiser',
    translating: 'Traduction...',
    replySuggestions: '💡 Suggestions de Réponse',
    copyButton: 'Copier',
    copied: 'Copié !',
    loading: 'Traitement...',
    error: 'Échec, veuillez réessayer',
    retry: 'Réessayer',
    minimize: 'Minimiser',
    expand: 'Développer',
    supportiveReply: 'Réponse de Soutien',
    inquisitiveReply: 'Réponse Interrogative',
    neutralReply: 'Réponse Neutre',
    welcomeFeature1: '📝 Traduction',
    welcomeFeature2: '💡 Suggestions Intelligentes',
    welcomeFeature3: '✍️ Traduction Personnalisée',
    welcomeTip: '💡 Astuce : Sélectionnez simplement le contenu du tweet avec votre souris',
    noAccessTitle: 'Abonnement Requis',
    noAccessMessage: 'Veuillez vous abonner ou entrer un nouveau code d\'activation',
    goToSettings: 'Aller aux Paramètres',
  },
  
  'de': {
    sidebarTitle: 'FluentX Tweet-Assistent',
    welcomeTitle: '✨ Tweet Auswählen zum Automatischen Übersetzen und Generieren von Antworten',
    welcomeText: '👆 Wählen Sie einen beliebigen Tweet auf der Seite aus, um ihn automatisch zu übersetzen und 3 Stile von Antwortvorschlägen zu generieren',
    quickTranslateTitle: '💬 Schnellübersetzung (Direkte Texteingabe)',
    dividerText: 'oder',
    summaryTitle: '📝 Zusammenfassung',
    summaryPrefix: '💡 ',
    tweetTranslation: '📝 Tweet-Übersetzung',
    customReply: '✍️ Benutzerdefinierte Antwort',
    customReplyPlaceholder: 'Geben Sie hier Ihren Text ein, klicken Sie auf Übersetzen, um ins Englische zu konvertieren...',
    translateButton: 'Übersetzen',
    translateTweetButton: 'Tweet Übersetzen',
    chatButton: 'Chat',
    refreshReplies: '🔄 Aktualisieren',
    translating: 'Tweet übersetzen...',
    generatingReplies: 'Antwortvorschläge generieren...',
    replySuggestions: '💡 Antwortvorschläge',
    copyButton: 'Kopieren',
    copied: 'Kopiert!',
    loading: 'Verarbeitung...',
    error: 'Fehlgeschlagen, bitte erneut versuchen',
    retry: 'Wiederholen',
    minimize: 'Minimieren',
    expand: 'Erweitern',
    supportiveReply: 'Unterstützende Antwort',
    inquisitiveReply: 'Fragende Antwort',
    neutralReply: 'Neutrale Antwort',
    welcomeFeature1: '📝 Übersetzung',
    welcomeFeature2: '💡 Intelligente Vorschläge',
    welcomeFeature3: '✍️ Benutzerdefinierte Übersetzung',
    welcomeTip: '💡 Tipp: Wählen Sie einfach den Tweet-Inhalt mit Ihrer Maus aus',
    noAccessTitle: 'Abonnement Erforderlich',
    noAccessMessage: 'Bitte abonnieren Sie oder geben Sie einen neuen Aktivierungscode ein',
    goToSettings: 'Zu den Einstellungen',
  },
  
  'pt': {
    sidebarTitle: 'Assistente de Tweets FluentX',
    welcomeTitle: '✨ Selecione Tweet para Traduzir e Gerar Respostas',
    welcomeText: '👆 Selecione qualquer tweet na página para traduzi-lo automaticamente e gerar 3 estilos de sugestões de resposta',
    quickTranslateTitle: '💬 Tradução Rápida (Entrada Direta de Texto)',
    dividerText: 'ou',
    summaryTitle: '📝 Resumo',
    summaryPrefix: '💡 ',
    tweetTranslation: '📝 Tradução de Tweet',
    customReply: '✍️ Resposta Personalizada',
    customReplyPlaceholder: 'Digite seu texto aqui, clique em traduzir para converter para o inglês...',
    translateButton: 'Traduzir',
    translateTweetButton: 'Traduzir Tweet',
    chatButton: 'Chat',
    refreshReplies: '🔄 Atualizar',
    translating: 'Traduzindo tweet...',
    generatingReplies: 'Gerando sugestões de resposta...',
    replySuggestions: '💡 Sugestões de Resposta',
    copyButton: 'Copiar',
    copied: 'Copiado!',
    loading: 'Processando...',
    error: 'Falhou, por favor tente novamente',
    retry: 'Tentar Novamente',
    minimize: 'Minimizar',
    expand: 'Expandir',
    supportiveReply: 'Resposta de Apoio',
    inquisitiveReply: 'Resposta Inquisitiva',
    neutralReply: 'Resposta Neutra',
    welcomeFeature1: '📝 Tradução',
    welcomeFeature2: '💡 Sugestões Inteligentes',
    welcomeFeature3: '✍️ Tradução Personalizada',
    welcomeTip: '💡 Dica: Simplesmente selecione o conteúdo do tweet com seu mouse',
    noAccessTitle: 'Assinatura Necessária',
    noAccessMessage: 'Por favor, assine ou insira um novo código de ativação',
    goToSettings: 'Ir para Configurações',
  },
  
  'ru': {
    sidebarTitle: 'Помощник для Твитов FluentX',
    welcomeTitle: '✨ Выберите Твит для Автоматического Перевода и Генерации Ответов',
    welcomeText: '👆 Выберите любой твит на странице для автоматического перевода и генерации 3 стилей предложений ответов',
    quickTranslateTitle: '💬 Быстрый Перевод (Прямой Ввод Текста)',
    dividerText: 'или',
    summaryTitle: '📝 Резюме',
    summaryPrefix: '💡 ',
    tweetTranslation: '📝 Перевод Твита',
    customReply: '✍️ Пользовательский Ответ',
    customReplyPlaceholder: 'Введите текст здесь, нажмите перевести для конвертации в английский...',
    translateButton: 'Перевести',
    translateTweetButton: 'Перевести Твит',
    chatButton: 'Чат',
    refreshReplies: '🔄 Обновить',
    translating: 'Перевод твита...',
    generatingReplies: 'Генерация предложений ответа...',
    replySuggestions: '💡 Предложения Ответов',
    copyButton: 'Копировать',
    copied: 'Скопировано!',
    loading: 'Обработка...',
    error: 'Ошибка, попробуйте еще раз',
    retry: 'Повторить',
    minimize: 'Свернуть',
    expand: 'Развернуть',
    supportiveReply: 'Поддерживающий Ответ',
    inquisitiveReply: 'Вопросительный Ответ',
    neutralReply: 'Нейтральный Ответ',
    welcomeFeature1: '📝 Перевод',
    welcomeFeature2: '💡 Умные Предложения',
    welcomeFeature3: '✍️ Пользовательский Перевод',
    welcomeTip: '💡 Совет: Просто выделите содержимое твита мышью',
    noAccessTitle: 'Требуется Подписка',
    noAccessMessage: 'Пожалуйста, подпишитесь или введите новый код активации',
    goToSettings: 'Перейти в Настройки',
  },
};

/**
 * 获取消息文本
 * @param {string} key - 消息键
 * @param {string} lang - 语言代码
 * @returns {string} - 翻译后的文本
 */
function getMessage(key, lang = 'zh-CN') {
  const messages = MESSAGES[lang] || MESSAGES['zh-CN'];
  return messages[key] || key;
}

/**
 * 获取当前语言的所有消息
 * @param {string} lang - 语言代码
 * @returns {Object} - 消息对象
 */
function getAllMessages(lang = 'zh-CN') {
  return MESSAGES[lang] || MESSAGES['zh-CN'];
}

