/**
 * 弹窗脚本
 */

// DOM 元素
const settingsBtn = document.getElementById('settingsBtn');
const headerContent = document.getElementById('headerContent');

/**
 * 打开设置页面
 */
function openSettings() {
  chrome.runtime.openOptionsPage();
}

/**
 * 初始化
 */
function init() {
  // 绑定事件
  settingsBtn.addEventListener('click', openSettings);
  
  // 点击头像和名称打开设置页面
  headerContent.addEventListener('click', openSettings);
  
  // 动态设置版本号
  const versionBadge = document.getElementById('versionBadge');
  if (versionBadge) {
    const version = chrome.runtime.getManifest().version;
    versionBadge.textContent = `v${version}`;
  }
}

// 页面加载完成后初始化
if (document.readyState === 'loading') {
  document.addEventListener('DOMContentLoaded', init);
} else {
  init();
}
